#!/bin/bash

# runner.sh - Script to run frpc client continuously

# Set paths
# Function to handle script termination
cleanup() {
    echo "$(date): Stopping runner script"
    exit 0
}

# Set up signal handlers
trap cleanup SIGINT SIGTERM

echo "$(date): Starting runner script"

# Main loop
while true; do
    echo "$(date): Starting client..."
    
    # Run frpc with the specified config file
    /root/miniconda3/envs/is-my-problem-new/bin/python -m src.build_summary
    # Get the exit status
    EXIT_STATUS=${PIPESTATUS[0]}
    
    echo "$(date): exited with status $EXIT_STATUS"
    
    # Wait before restarting (prevents rapid restart loops)
    echo "$(date): Waiting 5 seconds before restarting..."
    sleep 5
done
